package w83b.w83bOperacionesInternas.w83bImpugnaciones;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;

import org.apache.commons.lang.StringUtils;

import w83b.w83bBeans.W83bDocBeanImpug;
import w83b.w83bBeans.W83bImpugnacionBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInterna;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

public class W83bImpugnacionesAnyadirOIAction extends Q70OperacionInterna{
	/**
	 * preProcessMappingEntrada
	 * @param contexto a
	 * @param configBean a
	 * @param errors a
	 * @throws Exception e
	 */				
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean configBean, Q70OperacionInternaErrors errors) throws Exception{				
		
				
		if (contexto.get("w83bMapaFileImpugnaciones")!=null)
		{
			W83bImpugnacionBean preaviso = (W83bImpugnacionBean)contexto.get("w83bNuevaImpugnacionBean");
			HashMap mapaFiles =(HashMap)contexto.get("w83bMapaFileImpugnaciones");
			Iterator iter = mapaFiles.keySet().iterator();
			W83bDocBeanImpug docBean=null;
			while (iter.hasNext())
			{
				HashMap datosFile=(HashMap)mapaFiles.get(iter.next());
				docBean= new W83bDocBeanImpug();//NOPMD
				docBean.setNombre((String)datosFile.get("nombreDocumento"));
				docBean.setCodFase(((String)datosFile.get("tipodocumento")).split("_")[1]);
				docBean.setTipoDocumento(((String)datosFile.get("tipodocumento")).split("_")[0]);
				docBean.setCodTramite(((String)datosFile.get("tipodocumento")).split("_")[2]);
				docBean.setFechaRegistro((String)datosFile.get("fecharegistro"));
				docBean.setUsuario((String)datosFile.get("usuario"));
				docBean.setNumeroRegistro((String)datosFile.get("numregistro"));
				docBean.setFileData((InputStream)datosFile.get("documentoStream"));
				docBean.setTamanyo(((Long)datosFile.get("tamanyo")).intValue());
				preaviso.getListaDocs().add(docBean);

			}
		}

		super.preProcessMappingEntrada(contexto, configBean, errors);
			
	}
	
	/**
	 * postProcessMappingSalida
	 * @param contexto a
	 * @param errors a
	 * @throws Exception e
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors errors) throws Exception {

		String resultado = (String)contexto.get("w83bResultado");
		int fechaRegistro = resultado.split("_").length;
		if("-1".equals(resultado)){
			W83bUtilidadesComunes.anyadirMensajeErrorAplicacion(errors, "error.mensaje.baseDatosLlena", (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
		}else if("-2".equals(resultado)){
			W83bUtilidadesComunes.anyadirMensajeErrorAplicacion(errors, "error.mensaje.codImpugnacionyaExiste", (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
		}else if(3==fechaRegistro){
			W83bImpugnacionBean impug = (W83bImpugnacionBean)contexto.get("w83bNuevaImpugnacionBean");
			String[] datos=resultado.split("_");
			if(StringUtils.isNotEmpty(impug.getNum_registro())){
				impug.setNum_registro(datos[3]);
			}
			if(StringUtils.isNotEmpty(impug.getFecha_registro())){
				impug.setFecha_registro(datos[4]);
			}
			contexto.set("w83bNuevaImpugnacionBean",impug);
			contexto.set(W83bClsConstantes.CONSTANTE_MENSAJES_APLICACION_NO_ERROR, "comun.mensaje.bdActualizadaOkLibroRegistroError");
			contexto.set("modoPantalla",W83bClsConstantes.MODO_EDICION);
			
			String resul=datos[0]+"_"+datos[1]+"_"+datos[2];
			contexto.set("codSelecEdicion",resul);
		}else{
			
			W83bImpugnacionBean impug = (W83bImpugnacionBean)contexto.get("w83bNuevaImpugnacionBean");
			String[] datos=resultado.split("_");
			if(StringUtils.isNotEmpty(impug.getNum_registro())){
				impug.setNum_registro(datos[3]);
			}
			if(StringUtils.isNotEmpty(impug.getFecha_registro())){
				impug.setFecha_registro(datos[4]);
			}
			contexto.set("w83bNuevaImpugnacionBean",impug);
			contexto.set(W83bClsConstantes.CONSTANTE_MENSAJES_APLICACION_NO_ERROR, "comun.mensaje.bdActualizadaOk");
			contexto.set("modoPantalla",W83bClsConstantes.MODO_EDICION);
			
			String resul=datos[0]+"_"+datos[1]+"_"+datos[2];
			contexto.set("codSelecEdicion",resul);

		}
		
		super.postProcessMappingSalida(contexto, errors);
	}
}